<p align="center">
    <img title="Flutterwave" height="200" src="https://flutterwave.com/images/logo/full.svg" width="50%"/>
</p>

# Flutterwave v3 PHP SDK for Codeigniter 4.

![Packagist Downloads](https://img.shields.io/packagist/dt/seunex17/flutterwave-ci4)
![Packagist PHP Version Support](https://img.shields.io/packagist/php-v/seunex17/flutterwave-ci4)
![GitHub stars](https://img.shields.io/github/stars/seunex17/flutterwave-ci4)
![Packagist License](https://img.shields.io/packagist/l/seunex17/flutterwave-ci4)

This Flutterwave v3 PHP Library for Codeigniter4 provides easy access to Flutterwave for Business (F4B) v3 APIs from php
apps. It abstracts the complexity involved in direct integration and allows you to make quick calls to the APIs.

Available features include:

- Collections: Card, Account, Mobile money, Bank Transfers, USSD, Barter, NQR.
-
    - Flutterwave standard payment processing.
- Payouts and Beneficiaries.
- Recurring payments: Tokenization and Subscriptions.
- Split payments
- Card issuing
- Transactions dispute management: Refunds.
- Transaction reporting: Collections, Payouts, Settlements, and Refunds.
- Bill payments: Airtime, Data bundle, Cable, Power, Toll, E-bills, and Remitta.
- Identity verification: Resolve bank account, resolve BVN information.

## Table of Contents

1. [Requirements](#requirements)
2. [Installation](#installation)
3. [Contributing](#contribution-guidelines)
4. [License](#license)

<a id="requirements"></a>

# Requirements

1. Flutterwave for business [API Keys](https://developer.flutterwave.com/docs/integration-guides/authentication)
2. PHP >= 7.4
3. Codeigniter4

<a id="installation"></a>

## Installation

See the [docs](https://zubdev.gitbook.io/flutterwave-ci4/) for more specific instructions on installation and usage recommendations.

<a id="contribution-guidelines"></a>

## Contribution guidelines

this library is open for public to contribute.

<a id="license"></a>

## License

By contributing to this library, you agree that your contributions will be licensed under its [MIT license](/LICENSE).

<a id="references"></a>

## Flutterwave API  References

- [Flutterwave API Documentation](https://developer.flutterwave.com)
- [Flutterwave Dashboard](https://app.flutterwave.com)  
